<?php
require_once '../config/database.php';

// Check if user is admin (you should add admin field to users table)
if (!isset($_SESSION['admin']) || !$_SESSION['admin']) {
    redirect('../login.php');
}

$db = getDB();

// Get statistics
$total_users = $db->query("SELECT COUNT(*) as count FROM users")->fetch_assoc()['count'];
$total_emails = $db->query("SELECT COUNT(*) as count FROM email_pool")->fetch_assoc()['count'];
$used_emails = $db->query("SELECT COUNT(*) as count FROM email_pool WHERE status = 'used'")->fetch_assoc()['count'];
$available_emails = $db->query("SELECT COUNT(*) as count FROM email_pool WHERE status = 'available'")->fetch_assoc()['count'];

// Get recent purchases
$recent_purchases = $db->query("
    SELECT up.*, u.name, u.email, s.service_name 
    FROM user_purchases up 
    JOIN users u ON up.user_id = u.id 
    JOIN services s ON up.service_id = s.id 
    ORDER BY up.purchase_date DESC 
    LIMIT 10
");

// Get service usage
$service_usage = $db->query("
    SELECT s.service_name, 
           COUNT(up.id) as total_purchases,
           SUM(up.quantity) as total_quantity,
           SUM(up.used_count) as total_used
    FROM services s 
    LEFT JOIN user_purchases up ON s.id = up.service_id 
    GROUP BY s.id 
    ORDER BY s.service_name
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">Admin Panel</a>
            <div class="navbar-nav ms-auto">
                <a class="nav-item nav-link" href="manage-users.php">Manage Users</a>
                <a class="nav-item nav-link" href="manage-emails.php">Manage Emails</a>
                <a class="nav-item nav-link" href="../logout.php">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h2>Admin Dashboard</h2>
        
        <!-- Statistics -->
        <div class="row mt-4">
            <div class="col-md-3">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5>Total Users</h5>
                        <h2><?php echo $total_users; ?></h2>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5>Total Emails</h5>
                        <h2><?php echo $total_emails; ?></h2>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5>Used Emails</h5>
                        <h2><?php echo $used_emails; ?></h2>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <h5>Available Emails</h5>
                        <h2><?php echo $available_emails; ?></h2>
                    </div>
                </div>
            </div>
        </div>

        <!-- Service Usage -->
        <div class="card mt-4">
            <div class="card-header">
                <h4>Service Usage Statistics</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Service</th>
                            <th>Total Purchases</th>
                            <th>Total Quantity</th>
                            <th>Used</th>
                            <th>Available</th>
                            <th>Usage %</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($service = $service_usage->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $service['service_name']; ?></td>
                            <td><?php echo $service['total_purchases']; ?></td>
                            <td><?php echo $service['total_quantity'] ?: 0; ?></td>
                            <td><?php echo $service['total_used'] ?: 0; ?></td>
                            <td><?php echo ($service['total_quantity'] ?: 0) - ($service['total_used'] ?: 0); ?></td>
                            <td>
                                <?php 
                                if ($service['total_quantity'] > 0) {
                                    $percentage = ($service['total_used'] / $service['total_quantity']) * 100;
                                    echo number_format($percentage, 2) . '%';
                                } else {
                                    echo '0%';
                                }
                                ?>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Recent Purchases -->
        <div class="card mt-4">
            <div class="card-header">
                <h4>Recent Purchases</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>User</th>
                            <th>Service</th>
                            <th>Quantity</th>
                            <th>Used</th>
                            <th>Date</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($purchase = $recent_purchases->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $purchase['name']; ?><br><small><?php echo $purchase['email']; ?></small></td>
                            <td><?php echo $purchase['service_name']; ?></td>
                            <td><?php echo $purchase['quantity']; ?></td>
                            <td><?php echo $purchase['used_count']; ?></td>
                            <td><?php echo date('d M Y', strtotime($purchase['purchase_date'])); ?></td>
                            <td>
                                <span class="badge bg-<?php echo $purchase['status'] == 'active' ? 'success' : ($purchase['status'] == 'expired' ? 'warning' : 'secondary'); ?>">
                                    <?php echo ucfirst($purchase['status']); ?>
                                </span>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>