<?php
require_once 'config/database.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$db = getDB();
$user_id = $_SESSION['user_id'];

// Get user purchases
$stmt = $db->prepare("
    SELECT up.*, s.service_name, s.description 
    FROM user_purchases up 
    JOIN services s ON up.service_id = s.id 
    WHERE up.user_id = ? AND up.status = 'active'
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$purchases = $stmt->get_result();

// Get available emails for user
$stmt = $db->prepare("
    SELECT ep.*, s.service_name 
    FROM email_pool ep
    JOIN user_purchases up ON ep.id = up.email_pool_id
    JOIN services s ON up.service_id = s.id
    WHERE up.user_id = ? AND ep.status = 'assigned' AND up.status = 'active'
    AND up.used_count < up.quantity
    ORDER BY ep.email_address
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$assigned_emails = $stmt->get_result();

$db->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Email Service</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="#">Email Service</a>
            <div class="navbar-nav ms-auto">
                <span class="nav-item nav-link">Welcome, <?php echo $_SESSION['user_name']; ?></span>
                <a class="nav-item nav-link" href="logout.php">Logout</a>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        <h2>Dashboard</h2>
        
        <!-- Purchased Services -->
        <div class="card mt-4">
            <div class="card-header">
                <h4>Your Purchased Services</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php while($purchase = $purchases->fetch_assoc()): ?>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-body">
                                <h5><?php echo $purchase['service_name']; ?></h5>
                                <p><?php echo $purchase['description']; ?></p>
                                <p><strong>Quantity:</strong> <?php echo $purchase['quantity']; ?></p>
                                <p><strong>Used:</strong> <?php echo $purchase['used_count']; ?></p>
                                <p><strong>Remaining:</strong> <?php echo $purchase['quantity'] - $purchase['used_count']; ?></p>
                                <?php if ($purchase['expiry_date']): ?>
                                <p><strong>Expires:</strong> <?php echo date('d M Y', strtotime($purchase['expiry_date'])); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>

        <!-- Assigned Emails -->
        <div class="card mt-4">
            <div class="card-header">
                <h4>Your Assigned Emails</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Email Address</th>
                            <th>Service</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while($email = $assigned_emails->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $email['email_address']; ?></td>
                            <td><?php echo $email['service_name']; ?></td>
                            <td>
                                <span class="badge bg-success">Available</span>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="useEmail(<?php echo $email['id']; ?>, '<?php echo $email['service_name']; ?>')">
                                    Use for <?php echo $email['service_name']; ?>
                                </button>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Buy More Services -->
        <div class="card mt-4">
            <div class="card-header">
                <h4>Buy More Services</h4>
            </div>
            <div class="card-body">
                <?php
                $db = getDB();
                $services = $db->query("SELECT * FROM services ORDER BY service_name");
                ?>
                <div class="row">
                    <?php while($service = $services->fetch_assoc()): ?>
                    <div class="col-md-4 mb-3">
                        <div class="card">
                            <div class="card-body">
                                <h5><?php echo $service['service_name']; ?></h5>
                                <p><?php echo $service['description']; ?></p>
                                <p><strong>Price:</strong> $<?php echo $service['price_per_email']; ?> per email</p>
                                <form method="POST" action="purchase.php">
                                    <input type="hidden" name="service_id" value="<?php echo $service['id']; ?>">
                                    <div class="input-group">
                                        <input type="number" name="quantity" class="form-control" value="100" min="10" max="1000">
                                        <button type="submit" class="btn btn-success">Purchase</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
    function useEmail(emailId, serviceName) {
        if (confirm(`Use this email for ${serviceName}?`)) {
            fetch('use-email.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    email_id: emailId,
                    service_name: serviceName
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Email used successfully!');
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            });
        }
    }
    </script>
</body>
</html>