<?php
// Simple database setup script
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Database Setup - Email Service</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f5f5f5; padding: 20px; }
        .container { max-width: 800px; }
        .step { background: white; padding: 20px; border-radius: 5px; margin-bottom: 20px; border-left: 4px solid #007bff; }
        .code { background: #f8f9fa; padding: 10px; border-radius: 3px; font-family: monospace; }
        .success { border-color: #28a745; }
        .warning { border-color: #ffc107; }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="mb-4">Database Setup Guide</h1>
        
        <div class="step">
            <h3>Step 1: Create Database in CPanel</h3>
            <ol>
                <li>Login to your CPanel</li>
                <li>Go to <strong>MySQL Databases</strong></li>
                <li>Create new database: <code>skprotik_email_service</code></li>
                <li>Create database user: <code>skprotik_d1</code></li>
                <li>Set a strong password for the user</li>
                <li>Add user to database with <strong>ALL PRIVILEGES</strong></li>
            </ol>
        </div>
        
        <div class="step">
            <h3>Step 2: Update Configuration File</h3>
            <p>Edit <code>config/database.php</code> with your credentials:</p>
            <div class="code">
define('DB_HOST', 'localhost');<br>
define('DB_USER', 'skprotik_d1');<br>
define('DB_PASS', '<strong>YOUR_PASSWORD_HERE</strong>');<br>
define('DB_NAME', 'skprotik_email_service');
            </div>
        </div>
        
        <div class="step">
            <h3>Step 3: Create Database Tables</h3>
            <p>Import the SQL file in phpMyAdmin:</p>
            <ol>
                <li>Go to phpMyAdmin in CPanel</li>
                <li>Select your database</li>
                <li>Click on <strong>Import</strong> tab</li>
                <li>Choose <code>database/email_service_enhanced.sql</code></li>
                <li>Click <strong>Go</strong></li>
            </ol>
            
            <button class="btn btn-primary mt-3" onclick="createTables()">Create Tables Automatically</button>
            <div id="createTablesResult" class="mt-3"></div>
        </div>
        
        <div class="step">
            <h3>Step 4: Test Connection</h3>
            <a href="test-connection.php" class="btn btn-success">Test Database Connection</a>
        </div>
    </div>
    
    <script>
    function createTables() {
        const resultDiv = document.getElementById('createTablesResult');
        resultDiv.innerHTML = '<div class="alert alert-info">Creating tables...</div>';
        
        fetch('create-tables.php')
            .then(response => response.text())
            .then(data => {
                resultDiv.innerHTML = '<div class="alert alert-success">' + data + '</div>';
            })
            .catch(error => {
                resultDiv.innerHTML = '<div class="alert alert-danger">Error: ' + error + '</div>';
            });
    }
    </script>
</body>
</html>