<?php
require_once 'config/database.php';

$message = '';

if (isset($_GET['token'])) {
    $token = sanitize($_GET['token']);
    $db = getDB();
    
    $stmt = $db->prepare("SELECT id, verification_expiry FROM users WHERE verification_token = ? AND email_verified = 0");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        
        // Check if token is expired
        if (strtotime($user['verification_expiry']) > time()) {
            // Verify email
            $stmt = $db->prepare("UPDATE users SET email_verified = 1, verification_token = NULL, verification_expiry = NULL WHERE id = ?");
            $stmt->bind_param("i", $user['id']);
            
            if ($stmt->execute()) {
                $message = "Email verified successfully! You can now <a href='login.php'>login</a>.";
            } else {
                $message = "Verification failed. Please try again.";
            }
        } else {
            $message = "Verification link expired. Please register again.";
        }
    } else {
        $message = "Invalid or already used verification link.";
    }
    
    $db->close();
} else {
    $message = "No verification token provided.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body text-center">
                        <h3>Email Verification</h3>
                        <p><?php echo $message; ?></p>
                        <a href="login.php" class="btn btn-primary">Go to Login</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>